function [ Value ] = QSpline_Eval( dt, Fsample, P )
%Given a Delaunay and nodal values for a quad-spline query values
%  dt is an output of DelaundayTri.  This structure needed to use matlab's
%  locate points. fsample is a (numtri x 6 x 3) array. f(i,j,1) is
%  x-coordinate of jth node of triangle i.  Sim f(i,j,2) gives the
%  y-coordinates.  f(i,j,3) actually gives the spline's nodal value at
%  point { f(i,j,1), f(i,j,2) }.  f(i,1-3,:) are assumed to be the vertex
%  points of the triangle (crucial for the Tri_to_Std map). BUT f(i,4-6,:)
%  can be anything. P is a (numpt x 2) matrix with 1st column x-coordinates
%  and 2nd column y-coordinates of query points. 

numpt = size(P,1);

%Find triangles in which points P reside
tri = pointLocation(dt,P);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%For these triangles image the nodal and query points into the std element and build
%the corresponding Fstd for each triangle but as if it were std element.
Fstd = zeros(numpt, 6, 3);
Pstd = zeros(numpt,2);

for i=1:numpt
    %Get the triangle vertex data. First row are x-coordinates and 2nd y.
    %Then transpose it to format to Tri_to_Std
    T = [ [[Fsample(tri(i),1,1) Fsample(tri(i),2,1) Fsample(tri(i),3,1)]]; [[Fsample(tri(i),1,2) Fsample(tri(i),2,2) Fsample(tri(i),3,2)]] ]';
    
    %Get the miscellanously placed nodal data
    N = [ [[Fsample(tri(i),4,1) Fsample(tri(i),5,1) Fsample(tri(i),6,1)]]; [[Fsample(tri(i),4,2) Fsample(tri(i),5,2) Fsample(tri(i),6,2)]] ]';
    
    %Image the miscellaneous nodal into the std triangle
    S = Tri_to_Std(T, N); %Some care with Tri_to_Std just because one inverts a matrix.
    S = S'; %Puts x-vals in first row and y's in 2nd row
    
    %Image the query points into the Std Triangle. Have to use the i index,
    %because though all triangles going to std element, they all map
    %differently to it.
    Pstd(i,:) = Tri_to_Std(T, P(i,:)); %Keeps x-vals in 1st column and y-vals in 2nd column
    
    %Build the ith vertex data for Fstd.  We know the triangle vertices
    %were mapped to <e1,e2,0> in that order.
    
    Fstd(i,:,1) = [ [[1 0 0]] S(1,:) ]; %x-val's 
    Fstd(i,:,2) = [ [[0 1 0]] S(2,:) ]; %y-val's
    Fstd(i,:,3) = Fsample(tri(i),:,3); %Copy the Fsample vals
end
clear N S T
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Interpolate the different splines on the standard triangle.  Because we
%used barycentric coordinates, the pullback of a quadratic spline is a
%quadratic spline, so we may use Q_Terp here.

%In the rows store the spline coefficients on {1,x,y,xy,x^2,y^2} basis for
%Point i
C = zeros(numpt, 6);

for i=1:numpt
    N = [ Fstd(i,:,1)' Fstd(i,:,2)' ];
    p = Fstd(i,:,3)' ;
    C(i,:) = Q_Terp(N, p);%Courtesy Note: Bc we converted to std element, 
                          %the 'coefficients' here will not match those of 
                          %any quadratic polynomial that we took with
                          %Fsample; HOWEVER, the values are same up to
                          %numerical error. 
end
clear N p
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Use the coefficients to evaluate the spline at the points in question.
Value = zeros(numpt, 1);
Value(:,1) = C(:,1)+C(:,2).*Pstd(:,1)+C(:,3).*Pstd(:,2)+C(:,4).*Pstd(:,1).*Pstd(:,2)+C(:,5).*Pstd(:,1).^2+C(:,6).*Pstd(:,2).^2;

%for i=1:numpt
%    Value(i,1) = C(i,1)+C(i,2)*Pstd(i,1)+C(i,3)*Pstd(i,2)+C(i,4)*Pstd(i,1)*Pstd(i,2)+C(i,5)*Pstd(i,1)^2+C(i,6)*Pstd(i,2)^2;
%end

end

